/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;

public class GameScreen
extends AbstractPanelScreen {
    private static final int[][] RULES = new int[][]{{0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0, 0}};
    private Label keys;
    private Label stats;
    private Grid grid;
    private boolean paused = false;
    private static int scale = 5;

    protected GameScreen(Screen parentScreen) {
        super(parentScreen, (Component)Component.empty());
    }

    @Override
    public Class<? extends Screen> getSelectedPanel() {
        return this.parentScreen.getClass();
    }

    @Override
    protected void init() {
        super.init();
        this.removeWidget((GuiEventListener)this.panels);
        this.grid = new Grid(this.width, this.height);
        this.addRenderableOnly(this.grid);
        this.addRenderableWidget((GuiEventListener)new Button(this.width - 20, 4, 16, 16, 0, 0, 16, new FiguraIdentifier("textures/gui/search_clear.png"), 48, 16, (Component)FiguraText.of("gui.done"), bx -> this.onClose()));
        this.keys = new Label((Object)Component.empty().append((Component)Component.literal((String)"[R]").withStyle(FiguraMod.getAccentColor())).append(" restart, ").append((Component)Component.literal((String)"[P]").withStyle(FiguraMod.getAccentColor())).append(" pause, ").append((Component)Component.literal((String)"[SPACE]").withStyle(FiguraMod.getAccentColor())).append(" step").append("\n").append((Component)Component.literal((String)"[F1]").withStyle(FiguraMod.getAccentColor())).append(" hide text, ").append((Component)Component.literal((String)"[Scroll]").withStyle(FiguraMod.getAccentColor())).append(" scale (restarts)"), 4, 4, 0);
        this.addRenderableWidget(this.keys);
        this.stats = new Label((Object)"", 4, this.keys.getRawY() + this.keys.getHeight(), 0);
        this.addRenderableWidget(this.stats);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.paused) {
            this.grid.tick();
        }
        this.stats.setText((Component)Component.literal((String)"Generation").append((Component)Component.literal((String)(" " + this.grid.gen)).withStyle(FiguraMod.getAccentColor())).append(", Scale").append((Component)Component.literal((String)(" " + scale)).withStyle(FiguraMod.getAccentColor())));
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 82: {
                this.grid.init();
                break;
            }
            case 80: {
                this.paused = !this.paused;
                break;
            }
            case 32: {
                this.grid.tick();
                break;
            }
            case 290: {
                this.keys.setVisible(!this.keys.isVisible());
                this.stats.setVisible(!this.stats.isVisible());
                break;
            }
            default: {
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        scale = (int)Math.max(1.0, (double)scale + Math.signum(amount));
        this.grid.init();
        return true;
    }

    private static class Grid
    implements Renderable {
        private Cell[][] grid;
        private final int width;
        private final int height;
        private long gen = 0L;

        private Grid(int width, int height) {
            this.width = width;
            this.height = height;
            this.init();
        }

        private void init() {
            this.gen = 0L;
            int width = this.width / scale;
            int height = this.height / scale;
            this.grid = new Cell[width][height];
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Cell cell = new Cell(i, j, (int)Math.round(Math.random()));
                    if (i > 0) {
                        if (j > 0) {
                            cell.addNeighbor(this.grid[i - 1][j - 1]);
                        }
                        cell.addNeighbor(this.grid[i - 1][j]);
                        if (j < height - 1) {
                            cell.addNeighbor(this.grid[i - 1][j + 1]);
                        }
                    }
                    if (j > 0) {
                        cell.addNeighbor(this.grid[i][j - 1]);
                    }
                    this.grid[i][j] = cell;
                }
            }
        }

        private void tick() {
            ++this.gen;
            Cell[][] cellArray = this.grid;
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cells;
                for (Cell cell : cells = cellArray[i]) {
                    cell.update();
                }
            }
        }

        public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            PoseStack pose = gui.pose();
            pose.pushPose();
            pose.scale((float)scale, (float)scale, (float)scale);
            Cell[][] cellArray = this.grid;
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cells;
                for (Cell cell : cells = cellArray[i]) {
                    cell.render(gui);
                }
            }
            pose.popPose();
        }
    }

    private static class Cell {
        private final int x;
        private final int y;
        private int alive;
        private int future;
        private final ArrayList<Cell> neighbors = new ArrayList();
        private int color = -1;

        private Cell(int x, int y, int alive) {
            this.x = x;
            this.y = y;
            this.alive = alive;
            this.future = alive;
        }

        private void addNeighbor(Cell cell) {
            this.neighbors.add(cell);
            cell.neighbors.add(this);
        }

        private void update() {
            int neigh = 0;
            for (Cell cell : this.neighbors) {
                neigh += cell.alive;
            }
            this.future = RULES[this.alive][neigh];
        }

        private void render(GuiGraphics gui) {
            this.alive = this.future;
            if (this.alive == 1) {
                gui.fill(this.x, this.y, this.x + 1, this.y + 1, this.color);
            }
        }
    }
}

